function [d_val, u, w, phi]=VOMT(lambda0, lambda1, c12, c23, c13, alpha, options)
%later write padding functionality
%for now, n has to be a power of 2

n = size(lambda0);
n = n(1);

if ~( isreal(lambda0) && isreal(lambda1) )
    error('Input must be real');
end

if ~( isequal(size(lambda0),[n,n,3]) && isequal(size(lambda1),[n,n,3]) && isequal(size(lambda0),size(lambda1))  )
    error('lambda0 or lambda1 input size wrong');
end

if ~( (0.99<=sum(sum(sum(lambda0)))) && (sum(sum(sum(lambda0)))<=1.01) && (0.99<=sum(sum(sum(lambda1)))) && (sum(sum(sum(lambda1)))<=1.01) )
    error ('lambda0 and lambda1 must be normalized to 1');
end

tau = options.tau;

if (n==1)
    if tau==0
        tau = 1;
    end
    max_iter = 100;
elseif (n==2)
    if tau==0
        tau = 1;
    end
    max_iter = 200;
elseif (n==4)
    if tau==0
        tau = 1;
    end
    max_iter = 400;
elseif (n==8)
    if tau==0
        tau = 1;
    end
    max_iter = 1000;
elseif (n==16)
    if tau==0
        tau = 1;
    end
    max_iter = 1000;
elseif (n==32)
    if tau==0
        tau = 1;
    end
    max_iter = 1000;
elseif (n==64)
    if tau==0
        tau = 1;
    end
    max_iter = 1000;
elseif (n==128)
    if tau==0
        tau = 1;
    end
    max_iter = 1000;
elseif (n==256)
    if tau==0
        tau = 10;
    end
    max_iter = 100000;
else
    error('n has to be a power of 2');
end

mu = 1/(32*(n-1)^2*tau);

D=[1 0 1;
-1 1 0;
0 -1 -1];
nu = 1/(4*tau*eigs(D*diag([1/c12^2, 1/c23^2, 1/c13^2])*D',1));

%by default use l2 norm
u_norm_type = 2;
%by default use l1 norm
w_norm_type = 1;

if exist('options','var')
    if options.max_iter ~= 0
        max_iter = options.max_iter;
    end
    if strcmp(options.u_norm_type, 'l1 norm')
        u_norm_type = 1;
    elseif strcmp(options.u_norm_type,'l2 norm')
        u_norm_type = 2;
    elseif strcmp(options.u_norm_type, 'l12 norm')
        u_norm_type = 3;
    else
        error('incorrect norm type');
    end
    if strcmp(options.w_norm_type, 'l1 norm')
        w_norm_type = 1;
    elseif strcmp(options.w_norm_type, 'l2 norm')
        w_norm_type = 2;
    else
        error('incorrect norm type');
    end
end
if (nargout==4)
    [d_val, u, w, phi]=vomt_mex(lambda0, lambda1, c12, c23, c13, alpha, mu, nu, tau, max_iter, u_norm_type, w_norm_type);
else
    d_val=vomt_mex(lambda0, lambda1, c12, c23, c13,  alpha, mu, nu, tau, max_iter, u_norm_type, w_norm_type);
end
end
