function [d_val, u, phi]=SOMT(lambda0, lambda1,options)
%later write padding functionality
%for now, n has to be a power of 2

n = size(lambda0);
n = n(1);

if ~( isreal(lambda0) && isreal(lambda1) )
    error('Input must be real');
end

if ~( isequal(size(lambda0),[n,n]) && isequal(size(lambda1),[n,n]) && isequal(size(lambda0),size(lambda1))  )
    error('lambda0 or lambda1 input size wrong');
end

if ~( (0.99<=sum(sum(lambda0))) && (sum(sum(lambda0))<=1.01) && (0.99<=sum(sum(lambda1))) && (sum(sum(lambda1))<=1.01) )
    error ('lambda0 and lambda1 must be normalized to 1');
end

tau = options.tau;
if (n==1)
    if tau==0
        tau = 1;
    end
    max_iter = 100;
elseif (n==2)
    if tau==0
        tau = 1;
    end
    max_iter = 200;
elseif (n==4)
    if tau==0
        tau = 1;
    end
    max_iter = 400;
elseif (n==8)
    if tau==0
        tau = 1;
    end
    max_iter = 1000;
elseif (n==16)
    tau = 1;
    max_iter = 1000;
elseif (n==32)
    tau = 1;
    max_iter = 1000;
elseif (n==64)
    tau = 1;
    max_iter = 1000;
elseif (n==128)
    tau = 1;
    max_iter = 10000;
elseif (n==256)
    tau = 1;
    max_iter = 100000;
else
    error('n has to be a power of 2');
end
mu = 1/(16*(n-1)^2*tau);


%by default use l2 norm
norm_type = 2;

if exist('options','var')
    if options.max_iter ~= 0
        max_iter = options.max_iter;
    end
    if strcmp(options.norm_type, 'l1 norm')
        norm_type = 1;
    elseif strcmp(options.norm_type, 'l2 norm')
        norm_type = 2;
    else
        error('incorrect norm type');
    end
end
if (nargout==3)
    [d_val, u, phi]=somt_mex(lambda0, lambda1, mu, tau, max_iter, norm_type);
else
    d_val=somt_mex(lambda0, lambda1, mu, tau, max_iter, norm_type);
end
end
