function [d_val, U, W, Phi]=MOMT(Lambda0, Lambda1,L,alpha,options)
%later write padding functionality
%for now, n has to be a power of 2

n = size(Lambda0);
n = n(1);

if ~( isequal(size(Lambda0),[n,n,3,3]) && isequal(size(Lambda1),[n,n,3,3]) && isequal(size(Lambda0),size(Lambda1))  )
    error('Lambda0 or Lambda1 input size wrong');
end
temp = size(L);
if ~( (ndims(L)==3) && isequal(size(L),[3,3,temp(3)]) )
    error('L dimensions wrong');
end




if ~( (0.99<=trace(reshape(sum(sum(Lambda0)),3,3))) && (trace(reshape(sum(sum(Lambda0)),3,3))<=1.01) && (0.99<=trace(reshape(sum(sum(Lambda1)),3,3))) && (trace(reshape(sum(sum(Lambda1)),3,3))<=1.01) )
    error ('lambda0 and lambda1 must be normalized to 1');
end


tau = options.tau;

if (isreal(Lambda0) && isreal(Lambda1) && isreal(L))
    if (n==1)
        if tau==0
            tau = 1;
        end
        max_iter = 100;
    elseif (n==2)
        if tau==0
            tau = 1;
        end
        max_iter = 200;
    elseif (n==4)
        if tau==0
            tau = 1;
        end
        max_iter = 400;
    elseif (n==8)
        if tau==0
            tau = 1;
        end
        max_iter = 1000;
    elseif (n==16)
        if tau==0
            tau = 1;
        end
        max_iter = 1000;
    elseif (n==32)
        if tau==0
            tau = 1;
        end
        max_iter = 1000;
    elseif (n==64)
        if tau==0
            tau = 1;
        end
        max_iter = 1000;
    elseif (n==128)
        if tau==0
            tau = 1;
        end
        max_iter = 1000;
    elseif (n==256)
        if tau==0
            tau = 1;
        end
        max_iter = 1000;
    else
        error('n has to be a power of 2');
    end
    
    nu = 1/(4*tau*get_lap_L_lambda_max_real(L));
    mu = 1/(32*(n-1)^2*tau);
    

    %by default use l2 norm
    u_norm_type = 2;
    %by default use l1 norm
    w_norm_type = 1;
    
    if exist('options','var')
        if options.max_iter ~= 0
            max_iter = options.max_iter;
        end
        
        if strcmp(options.u_norm_type, 'l1 norm')
            u_norm_type = 1;
        elseif strcmp(options.u_norm_type, 'l2 norm')
            u_norm_type = 2;
        elseif strcmp(options.u_norm_type, 'nuclear norm')
            u_norm_type = 3;
        else
            error('incorrect norm type');
        end
        
        if strcmp(options.w_norm_type, 'l1 norm')
            w_norm_type = 1;
        elseif strcmp(options.w_norm_type, 'l2 norm')
            w_norm_type = 2;
        elseif strcmp(options.w_norm_type, 'nuclear norm')
            w_norm_type = 3;
        else
            error('incorrect norm type');
        end
    end
    if (nargout==4)
        [d_val, U, W, Phi]=momt_real_mex(Lambda0, Lambda1, L, alpha, mu, nu, tau, max_iter, u_norm_type, w_norm_type);
    else
        d_val=momt_real_mex(Lambda0, Lambda1, L, alpha, mu, nu, tau, max_iter, u_norm_type, w_norm_type);
    end
    
else
    if (n==1)
        if tau==0
            tau = 1;
        end
        max_iter = 1000;
    elseif (n==2)
        if tau==0
            tau = 1;
        end
        max_iter = 200;
    elseif (n==4)
        if tau==0
            tau = 1;
        end
        max_iter = 400;
    elseif (n==8)
        if tau==0
            tau = 1;
        end
        max_iter = 1000;
    elseif (n==16)
        if tau==0
            tau = 1;
        end
        max_iter = 1000;
    elseif (n==32)
        tau = 1;
        max_iter = 1000;
    elseif (n==64)
        if tau==0
            tau = 1;
        end
        max_iter = 1000;
    elseif (n==128)
        if tau==0
            tau = 1;
        end
        max_iter = 1000;
    elseif (n==256)
        if tau==0
            tau = 1;
        end
        max_iter = 1000;
    else
        error('n has to be a power of 2');
    end
    
    nu = 1/(4*tau*get_lap_L_lambda_max_complex(L));
    mu = 1/(32*(n-1)^2*tau);
    

    
    %by default use l2 norm
    u_norm_type = 2;
    %by default use l1 norm
    w_norm_type = 1;
    
    if exist('options','var')
        if options.max_iter ~= 0
            max_iter = options.max_iter;
        end
        
        if strcmp(options.u_norm_type, 'l1 norm')
            u_norm_type = 1;
        elseif strcmp(options.u_norm_type, 'l2 norm')
            u_norm_type = 2;
        else
            error('incorrect norm type');
        end
        
        if strcmp(options.w_norm_type, 'l1 norm')
            w_norm_type = 1;
        elseif strcmp(options.w_norm_type, 'l2 norm')
            w_norm_type = 2;
        else
            error('incorrect norm type');
        end
    end
    
    
    if (nargout==4)
        [d_val, U, W, Phi]=momt_complex_mex(complex(Lambda0), complex(Lambda1), complex(L), alpha, mu, nu, tau, max_iter, u_norm_type, w_norm_type);
    else
        d_val=momt_complex_mex(complex(Lambda0), complex(Lambda1), complex(L), alpha, mu, nu, tau, max_iter, u_norm_type, w_norm_type);
    end
    
    
end

end
